<?php
// Define categories and their products here
$categories = [
     'سرور مخصوص ایرانسل1' => [
        ['name' => ' پلن 1', 'price' => 45000, 'time' => '1 ماه', 'size' => '10 گیگابایت', 'users' => ' کاربر نامحدود'],
        ['name' => ' پلن 2', 'price' => 70000, 'time' => '1 ماه', 'size' => '30 گیگابایت', 'users' => ' کاربر نامحدود'],
        ['name' => ' پلن 3', 'price' => 120000, 'time' => '1 ماه', 'size' => '50 گیگابایت', 'users' => ' کاربر نامحدود'],
        ['name' => ' پلن 4', 'price' => 138000, 'time' => '2ماه و 7 روز', 'size' => '60 گیگابایت', 'users' => ' کاربر نامحدود'],
        ['name' => ' پلن 5', 'price' => 235000, 'time' => '2ماه و 7 روز', 'size' => '100 گیگابایت', 'users' => ' کاربر نامحدود'],

    ],
        'سرور مخصوص ایرانسل2' => [
        ['name' => ' پلن 1', 'price' => 100000, 'time' => '1 ماه', 'size' => '40 گیگابایت', 'users' => ' کاربر نامحدود'],
        ['name' => ' پلن 2', 'price' => 199000, 'time' => '2ماه و 7 روز', 'size' => '100 گیگابایت', 'users' => ' کاربر نامحدود'],

    ],
    'سرور نرمال (تمامی اینترنت ها)' => [
        ['name' => ' پلن 1', 'price' => 60000, 'time' => '1 ماه', 'size' => '10 گیگابایت', 'users' => ' کاربر نامحدود'],
        ['name' => ' پلن 2', 'price' => 85000, 'time' => '1 ماه', 'size' => '30 گیگابایت', 'users' => ' کاربر نامحدود'],
        ['name' => ' پلن 3', 'price' => 114000, 'time' => '1 ماه', 'size' => '40 گیگابایت', 'users' => ' کاربر نامحدود'],
        ['name' => ' پلن 4', 'price' => 139000, 'time' => '1 ماه', 'size' => '50 گیگابایت', 'users' => ' کاربر نامحدود'],
        ['name' => ' پلن 5', 'price' => 229000, 'time' => '2ماه و 7 روز', 'size' => '80 گیگابایت', 'users' => ' کاربر نامحدود'],
        ['name' => ' پلن 6', 'price' => 279000, 'time' => '2ماه و 7 روز', 'size' => '100 گیگابایت', 'users' => ' کاربر نامحدود'],


    ],
    'سرور VIP (تمامی اینترنت ها)' => [
        ['name' => ' پلن 1', 'price' => 75000, 'time' => '1 ماه', 'size' => '10 گیگابایت', 'users' => ' کاربر نامحدود'],
        ['name' => ' پلن 2', 'price' => 99000, 'time' => '1 ماه', 'size' => '30 گیگابایت', 'users' => ' کاربر نامحدود'],
        ['name' => ' پلن 3', 'price' => 129000, 'time' => '1 ماه', 'size' => '40 گیگابایت', 'users' => ' کاربر نامحدود'],
        ['name' => ' پلن 4', 'price' => 154000, 'time' => '1 ماه', 'size' => '50 گیگابایت', 'users' => ' کاربر نامحدود'],
        ['name' => ' پلن 5', 'price' => 249000, 'time' => '2ماه و 7 روز', 'size' => '80 گیگابایت', 'users' => ' کاربر نامحدود'],
        ['name' => ' پلن 6', 'price' => 294000, 'time' => '2ماه و 7 روز', 'size' => '100 گیگابایت', 'users' => ' کاربر نامحدود'],

    ],
];
?>
<!DOCTYPE html>
<html lang="fa">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>محصولات</title>
    <style>
        @font-face {
            font-family: 'IranSans';
            src: url('https://cdn.jsdelivr.net/gh/rastikerdar/iransans-web/dist/font-face/IRANSansWeb.ttf') format('truetype');
        }
        body {
            background: rgba(255, 255, 255, 0.8);
            backdrop-filter: blur(5px);
            font-family: 'IranSans', Arial, sans-serif;
            background: url('https://alirezapc.ir/videos/logo.png') no-repeat center center fixed;
            background-size: cover;
            margin: 0;
            padding: 0;
            direction: rtl;
        }

        header {
            text-align: center;
            background-color: #3b5998;
            color: white;
            padding: 20px;
            box-shadow: 0px 4px 6px rgba(0, 0, 0, 0.2);
        }

        header h1 {
            font-size: 28px;
            margin: 0;
        }

        #controls {
            margin: 20px;
            text-align: center;
        }

        select {
            padding: 10px;
            border: 1px solid #ddd;
            border-radius: 5px;
            font-family: 'IranSans', Arial, sans-serif;
            background-color: #ffffff;
            box-shadow: 0px 2px 4px rgba(0, 0, 0, 0.1);
            transition: all 0.3s ease;
        }

        select:hover {
            border-color: #4caf50;
        }

        #productList {
            display: flex;
            flex-wrap: wrap;
            justify-content: center;
            gap: 15px;
            padding: 20px;
        }

        .product {
            background-color: white;
            border: 1px solid #ddd;
            border-radius: 10px;
            text-align: center;
            width: 100%;
            max-width: 220px;
            padding: 20px;
            box-shadow: 0px 4px 6px rgba(0, 0, 0, 0.1);
            opacity: 0;
            transform: translateY(20px);
            animation: fadeIn 0.6s forwards;
        }

        .product h3 {
            font-size: 20px;
            margin-bottom: 10px;
            color: #333;
        }

        .product p {
            margin: 5px 0;
            color: #555;
            font-size: 14px;
        }

        .product:nth-child(odd) {
            background-color: #f9f9f9;
        }

        button {
            background-color: #4caf50;
            color: white;
            border: none;
            padding: 10px 20px;
            cursor: pointer;
            border-radius: 5px;
            font-size: 14px;
            transition: background-color 0.3s ease;
        }

        button:hover {
            background-color: #45a049;
        }

        /* Fade-in Animation */
        @keyframes fadeIn {
            0% {
                opacity: 0;
                transform: translateY(20px);
            }
            100% {
                opacity: 1;
                transform: translateY(0);
            }
        }

        /* Fade box for descriptions */
        .fade-box {
            margin: 20px auto;
            padding: 15px;
            background-color: rgba(0, 0, 0, 0.6);
            color: white;
            border-radius: 10px;
            max-width: 600px;
            text-align: center;
            font-size: 16px;
            line-height: 1.8;
            animation: fadeIn 0.8s forwards;
        }

        .fade-box.hidden {
            display: none;
        }
    </style>
</head>
<body>
    <header>
        <h1>محصولات ما</h1>
    </header>

    <div id="controls">
        <select id="categoryFilter" onchange="filterProducts()">
            <?php foreach ($categories as $category => $products): ?>
                <option value="<?= htmlspecialchars($category) ?>" <?= ($category === 'سرور مخصوص ایرانسل1') ? 'selected' : '' ?>>
                    <?= htmlspecialchars($category) ?>
                </option>
            <?php endforeach; ?>
        </select>
    </div>

    <div id="productList">
        <?php foreach ($categories as $category => $products): ?>
            <?php foreach ($products as $product): ?>
                <div class="product" data-category="<?= htmlspecialchars($category) ?>" 
                    style="<?= ($category === 'سرور مخصوص ایرانسل1') ? 'display: block;' : 'display: none;' ?>">
                    <h3>
                        <?= ($category === 'سرور VIP (تمامی اینترنت ها)') ? '💎 ' : '' ?>
                        <?= ($category === 'سرور نرمال (تمامی اینترنت ها)') ? '🌟 ' : '' ?>
                        <?= ($category === 'سرور مخصوص ایرانسل1' || $category === 'سرور مخصوص ایرانسل2') ? '🚀 ' : '' ?>
                        <?= htmlspecialchars($product['name']) ?>
                    </h3>
                    <p>💰 قیمت: <?= number_format($product['price']) ?> تومان</p>
                    <p>⏳ مدت‌زمان: <?= htmlspecialchars($product['time']) ?></p>
                    <p>📦 حجم: <?= htmlspecialchars($product['size']) ?></p>
                    <p>👥 تعداد کاربر: <?= htmlspecialchars($product['users']) ?></p>
                </div>
            <?php endforeach; ?>
        <?php endforeach; ?>
    </div>

    <div id="descriptionBox" class="fade-box hidden"></div>

    <script>
        const descriptions = {
            "سرور مخصوص ایرانسل1": `
                توضیحات: <br>
                ♾ کاربر نامحدود <br>
                ✅ یک لوکیشن فعال خواهید داشت <br>
                ✅ آی‌پی ثابت ✨ <br>
                ✅ مخصوص کاربران اینترنت ایرانسل، TDLTE و رایتل
            `,
            "سرور مخصوص ایرانسل2": `
                توضیحات: <br>
                ♾ کاربر نامحدود <br>
                ✅ یک لوکیشن فعال خواهید داشت <br>
                ✅ آی‌پی ثابت ✨ <br>
                ✅ مخصوص کاربران اینترنت ایرانسل، TDLTE و رایتل
            `,
            "سرور نرمال (تمامی اینترنت ها)": `
                توضیحات: <br>
                ♾ کاربر نامحدود ♾ <br>
                ✅ یک لوکیشن فعال <br>
                ✅ تانل شده نت ملی 🎚 <br>
                ✅ سرور اختصاصی ایران 🇮🇷 <br>
                ✅ آی پی ثابت ✨ <br>
                ✅ قابلیت اتصال با کلیه اپراتورها 💯
            `,
            "سرور VIP (تمامی اینترنت ها)": `
                توضیحات: <br>
                ♾ کاربر نامحدود ♾ <br>
                🌐 چهارده لوکیشن فعال: فرانسه | 2 آلمان | ترکیه | فنلاند | هلند | اسپانیا | اسلوونی | سوئد | اوکراین | قزاقستان | انگلستان | امریکا | دبی <br>
                ✅ تانل شده نت ملی 🎚 <br>
                ✅ سرور اختصاصی ایران 10گیگابیتی 🇮🇷 <br>
                ✅ آی پی ثابت ✨ <br>
                ✅ قابلیت اتصال با کلیه اپراتورها 💯 <br>
                ✅ نگران قطعی نباشید و بین کشورها سوئیچ کنید <br>
                ✅ پورت اختصاصی برای هرشخص ⚡️ <br>
                ✅ سرعت فوق العاده بالا ⚡️ <br>
                ✅ بدون قطعی با پشتیبانی 24 ساعته 💻 <br>
                ✅ حجم نیم بها 👑 یعنی به ازای هر 2 گیگ دانلود، 1 گیگ محاسبه خواهد شد 🔄
            `
        };

        function filterProducts() {
            const category = document.getElementById("categoryFilter").value;
            const products = document.querySelectorAll(".product");
            const descriptionBox = document.getElementById("descriptionBox");

            products.forEach(product => {
                product.style.display = product.dataset.category === category ? "block" : "none";
            });

            // Update description box content
            if (descriptions[category]) {
                descriptionBox.innerHTML = descriptions[category];
                descriptionBox.classList.remove("hidden");
            } else {
                descriptionBox.classList.add("hidden");
            }
        }

        // Show "سرور مخصوص ایرانسل1" products by default on page load
        window.onload = function () {
            filterProducts();
        };
    </script>
</body>
</html>
